<?xml version="1.0" encoding="UTF-8"?>
<!-- XML style sheet for movie-watcher XML - extract movies and sort
     Written by Keith Wood, 9 March 2002 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml"/>

<!-- Match the entire document -->
<xsl:template match="/">
  <html>
  <head>
  <title>Movies</title>
  </head>
  <body>
  <h1>Movies</h1>
  <p>These movies are currently showing:</p>
  <xsl:apply-templates select="//movie">
    <xsl:sort select="name"/>
  </xsl:apply-templates>
  </body>
  </html>
</xsl:template>

<!-- Display a movie -->
<xsl:template match="movie">
  <h3><xsl:value-of select="name"/></h3>
  <table border="0">
  <tr><th>Length:</th><td><xsl:value-of select="length"/></td>
    <th>Rating:</th><td><xsl:value-of select="@rating"/></td></tr>
  <tr><th align="left" valign="top">Director:</th>
    <td colspan="3"><xsl:value-of select="director"/></td></tr>
  <tr><th align="left" valign="top">Starring:</th>
    <td colspan="3"><xsl:apply-templates select=".//star"/></td></tr>
  <tr><th align="left" valign="top">Synopsis:</th>
    <td colspan="3"><xsl:value-of select="synopsis"/></td></tr>
  </table>
</xsl:template>

<!-- Display a star -->
<xsl:template match="star">
  <xsl:value-of select="."/><br />
</xsl:template>

</xsl:stylesheet>
